using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Oko
{
	/// <summary>
	/// Summary description for WinForm1.
	/// </summary>
	public class Oko_Katalogi : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		public JacekMatulewski.Util.FileListBox fileListBox1;
		public Form oknoGlowne=null;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;

		public Oko_Katalogi()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//

			this.Height=3*Screen.PrimaryScreen.Bounds.Height/4;
			this.Top=Screen.PrimaryScreen.Bounds.Height/16;
			this.Left=Screen.PrimaryScreen.Bounds.Width-3*this.Width/2;
			fileListBox1_DirectoryPathChanged(null,null);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Oko_Katalogi));
			this.fileListBox1 = new JacekMatulewski.Util.FileListBox();
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.SuspendLayout();
			// 
			// fileListBox1
			// 
			this.fileListBox1.ContextMenu = this.contextMenu1;
			this.fileListBox1.DirectoriesVisible = true;
			this.fileListBox1.DirectoryChangeAllowed = true;
			this.fileListBox1.DirectoryPath = ".";
			this.fileListBox1.DirectoryWatchingEnabled = true;
			this.fileListBox1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.fileListBox1.DoubleDotVisible = true;
			this.fileListBox1.DrivesVisible = true;
			this.fileListBox1.FilesVisible = true;
			this.fileListBox1.Filter = null;
			this.fileListBox1.Location = new System.Drawing.Point(0, 0);
			this.fileListBox1.Name = "fileListBox1";
			this.fileListBox1.SelectionMode = System.Windows.Forms.SelectionMode.One;
			this.fileListBox1.Size = new System.Drawing.Size(292, 268);
			this.fileListBox1.TabIndex = 0;
			this.fileListBox1.DirectoryPathChanged += new JacekMatulewski.Util.FileListBox.SelectedFileChangedEventHandler(this.fileListBox1_DirectoryPathChanged);
			this.fileListBox1.MouseUp += new System.Windows.Forms.MouseEventHandler(this.fileListBox1_MouseUp);
			this.fileListBox1.FileDoubleClicked += new JacekMatulewski.Util.FileListBox.FileDoubleClickedEventHandler(this.fileListBox1_FileDoubleClicked);
			this.fileListBox1.MouseMove += new System.Windows.Forms.MouseEventHandler(this.fileListBox1_MouseMove);
			this.fileListBox1.MouseLeave += new System.EventHandler(this.fileListBox1_MouseLeave);
			this.fileListBox1.MouseDown += new System.Windows.Forms.MouseEventHandler(this.fileListBox1_MouseDown);
			// 
			// contextMenu1
			// 
			this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem1,
						this.menuItem2});
			this.contextMenu1.Popup += new System.EventHandler(this.contextMenu1_Popup);
			// 
			// menuItem1
			// 
			this.menuItem1.DefaultItem = true;
			this.menuItem1.Index = 0;
			this.menuItem1.Text = "Wywietl obraz z pliku";
			this.menuItem1.Click += new System.EventHandler(this.menuItem1_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.Text = "Dodaj plik do koszyka";
			this.menuItem2.Click += new System.EventHandler(this.menuItem2_Click);
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 246);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Size = new System.Drawing.Size(292, 22);
			this.statusBar1.TabIndex = 1;
			this.statusBar1.Text = "statusBar1";
			// 
			// Oko_Katalogi
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(292, 268);
			this.Controls.Add(this.statusBar1);
			this.Controls.Add(this.fileListBox1);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "Oko_Katalogi";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
			this.Text = "Oko - Katalogi";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.Oko_Katalogi_Closing);
			this.ResumeLayout(false);
		}
		#endregion

		private void fileListBox1_FileDoubleClicked(object sender, System.EventArgs e, string fileName)
		{
			((WinForm)oknoGlowne).wczytajObrazZPliku(fileName,true);
		}

		private void fileListBox1_DirectoryPathChanged(object sender, System.EventArgs e)
		{
			statusBar1.Text="Katalog: "+fileListBox1.DirectoryPath;
		}


		#region drag'n'drop
		private const int dragDistance=5;

		private bool mouseClicked=false;
		private Point mouseClickedPos;

		private void fileListBox1_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if (e.Button==MouseButtons.Left && System.IO.File.Exists(fileListBox1.FileName))
				{
				mouseClicked=true;
				mouseClickedPos=new Point(e.X,e.Y);
				}
		}

		private void fileListBox1_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			mouseClicked=false;
		}

		private void fileListBox1_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if (mouseClicked)
				{
				int dx=e.X-mouseClickedPos.X;
				int dy=e.Y-mouseClickedPos.Y;
				double distance=Math.Sqrt(dx*dx+dy*dy);
				if (distance>=dragDistance)
					{
					fileListBox1.DoDragDrop(fileListBox1.FileName,DragDropEffects.Copy);
					mouseClicked=false;
					}
				}
		}

		private void fileListBox1_MouseLeave(object sender, System.EventArgs e)
		{
			mouseClicked=false;
		}
		#endregion

		private void Oko_Katalogi_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			e.Cancel=true;
			this.Hide();
		}

		private void contextMenu1_Popup(object sender, System.EventArgs e)
		{

		}

		private void menuItem1_Click(object sender, System.EventArgs e)
		{
			string nazwaPliku=fileListBox1.FileName;
			if (nazwaPliku=="" || !System.IO.File.Exists(nazwaPliku)) return;
			fileListBox1_FileDoubleClicked(sender,e,fileListBox1.FileName);
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			string nazwaPliku=fileListBox1.FileName;
			if (nazwaPliku=="" || !System.IO.File.Exists(nazwaPliku)) return;
			((WinForm)oknoGlowne).oknoKoszyk.listBox1.Items.Add(nazwaPliku);
		}
	}
}
